VERSION ("DAT file 1.0")

'**********************************************************************************************************************
'
'  Sample Program for File ( DAT TYPE ) Commands
'
'  Target Machine : CPT-711
'
'  Commands :
'	EMPTY_TRANSACTION : To remove all the transaction data from a default transaction file.
'
'	SAVE_TRANSACTION : To save (append) a transaction record to the default transaction file.
'
'     	A% = TRANSACTION_COUNT : To get the total number of the transaction records saved in the
'					 default transaction file.
'
'     	UPDATE_TRANSACTION(N%, data$) : To update a transaction record in the default transaction file.
'
'	DEL_TRANSACTION_DATA(N%) : To remove a block of transaction data from the default transaction file.
'
'	A$ = GET_TRANSACTION_DATA$ (N%) : To read a transaction record from the default transaction file.
'
'  Transaction Files : DAT #1 => Fix data length 12.
'
'**********************************************************************************************************************

	DIM FileDAT$(5)

100	
	CLS
	LOCATE 1,3
	PRINT "FILE (DAT) TEST"

	EMPTY_TRANSACTION


'**********     Save Transaction     **********

	FOR i% = 1 TO 5
		FileDAT$(i%) = "APPEND DATA" + STR$(i%)
		SAVE_TRANSACTION(FileDAT$(i%))
	NEXT i%

	LOCATE 3,1
	PRINT "APPEND DATA OK."
			
	GOSUB GetRecordCountToShow
	BEEP(2000,5)
	WAIT(500)


'**********     Update Transaction     **********

	FileD$ = "UPDATE DATA1"
	UPDATE_TRANSACTION(3, FileD$)

	LOCATE 4,1
	PRINT "UPDATE DATA OK."

	GOSUB GetRecordCountToShow
	BEEP(2000,5)
	WAIT(500)


'**********     Del Transaction     **********

	DEL_TRANSACTION_DATA(1)	

	LOCATE 5,1
	PRINT "DEL DATA OK."

	GOSUB GetRecordCountToShow
	BEEP(2000,5)

	LOCATE 7,1
	PRINT "PRESS [ENT] KEY"
	INPUT A$	


'**********     Get Transaction Data     **********

	CLS
	LOCATE 1,3
	PRINT "FILE (DAT) TEST"

	GOSUB GetRecordCountToShow

	FOR i% = 1 TO FileRecord%	
		FileDAT$(i%) = GET_TRANSACTION_DATA$(i%)				

		LOCATE i%+2,1
		PRINT FileDAT$(i%)
		WAIT(100)
	NEXT i%	

	LOCATE 7,1
	PRINT "PRESS [ENT] KEY"
	INPUT A$


	GOTO 100


'**********     SUB for showing Record count     **********

GetRecordCountToShow:

	FileRecord% = TRANSACTION_COUNT

	LOCATE 8,10
	PRINT "RECORD:"; FileRecord%
	RETURN

